﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;
using Gemini.Core.JSON.LitJson;
using System.Xml.Xsl;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodCompetencesSave : BaseAPIMethod
        {
            private long _context_id = -1;
            private long _course_id = -1;
            private long _unit_id = -1;
            private long _exercise_id = -1;
            private int _mode_id = 0;
            private string _data = null;

            public MethodCompetencesSave(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "competencessave"; }
            }

            protected override bool DoValidate()
            {
                return (_context_id > 0) && (_course_id > 0) && (_unit_id > 0) && (_exercise_id > 0) && (!string.IsNullOrEmpty(_data));
            }

            protected override void DoReadRequestParams()
            {
                long.TryParse(Component.APIRequestParams["context_id"], out _context_id);
                long.TryParse(Component.APIRequestParams["course_id"], out _course_id);
                long.TryParse(Component.APIRequestParams["unit_id"], out _unit_id);
                long.TryParse(Component.APIRequestParams["exercise_id"], out _exercise_id);
                int.TryParse(Component.APIRequestParams["mode_id"], out _mode_id);
                _data = Component.APIRequestParams["data"];
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (User != null)
                {
                    XslCompiledTransform _apiXSLTransform = Component.WebPageEngine.ComponentXSL("c_apimobile");

                    try
                    {
                        GExerciseDataCheck _GExerciseDataCheck = JsonMapper.ToObject<GExerciseDataCheck>(_data);

                        BL.ZSBELearning.ContextParam _contextParam = new BL.ZSBELearning.ContextParam(Component.BLELearning, _context_id, _course_id, _unit_id, _exercise_id, null, _mode_id);
                        _contextParam.ExerciseState = GM.N610.ELearning.BL.ELearning.ExerciseState.Check;

                        GResponseData _GResponseData = Component.BLELearning.APIMobile.CheckExercise(_contextParam, _apiXSLTransform, _GExerciseDataCheck.ExerciseData);
                        if (_GResponseData != null)
                        {
                            StatusCode = StatusCodeType.OK;
                            return _GResponseData;
                        }
                        else
                        {
                            AddErrorMessage("Nie znaleziono ćwiczenia dla zadanych parametrów.");
                            StatusCode = StatusCodeType.NotFound;
                        }
                    }
                    catch
                    {
                        AddErrorMessage("Niepoprawny ciąg danych wejściowych do zapisu ćwiczenia.");
                        StatusCode = StatusCodeType.BadRequest;
                    }
                }
                return null;
            }
        }
    }
}
